import numpy as np
import GPy  # Gaussian Processes library



class ExtBound():
    def __init__(self, func, thres, rho=0.3, eta=3):
        self.func = func
        self.thres = np.abs( thres)
        # bound: [X.shape[1], 2]
        self.int_bound = None
        self.ext_bound = None
        self.rho = rho
        self.eta = eta


    def fit(self, X, s, int_bound=None):
        self.init_bound(int_bound, X.shape[1])
        X_inlier, X_outlier = X[s <= self.thres], X[s > self.thres]
        s_inlier, s_outlier = s[s <= self.thres], s[s > self.thres]
        y = (s_inlier <= self.thres).astype(int)

        if X_inlier.shape[0] == 0:
            self.ext_bound[:, 1] = -np.inf
            return

        for j in range(X.shape[1]):
            kernel = GPy.kern.RBF(input_dim=1, variance=1 , lengthscale=1)

            X_val = X_inlier[:, j]

            X_val = np.sort(X_val)

            X_inlier_min = np.min(X_val)
            X_inlier_max = np.max(X_val)
            if X_inlier_min == X_inlier_max:
                sigma = 1e-4  


                perturbation = np.random.normal(loc=0, scale=sigma, size=X_val.shape)


                X_val = X_val + perturbation
                X_val = np.sort(X_val)


            X_input =X[:,j]
            self.GPs = GPy.models.GPRegression(X_val[:,None], y[:,None], kernel)

            self.GPs.optimize(messages=False)
            X_tmp =X_val
            if X_val.shape[0] >700:

                X_inlier_min = np.min(X_val)
                X_inlier_max = np.max(X_val)
                diff = X_inlier_max - X_inlier_min
                diff = diff*self.rho


                part1 = X_val[(X_val >= X_inlier_min) & (X_val <= X_inlier_min + diff)]


                part2 = X_val[(X_val >= X_inlier_max - diff) & (X_val <= X_inlier_max)]


                sampels = np.concatenate([part1, part2])
                sampels = np.unique(sampels)
            else:
                sampels = X_val


            X_val = sampels
            diff = X_inlier_max - X_inlier_min
            if np.min(X[:,j]) == np.max(X[:,j]):
                diff = self.rho
            else:
                diff = diff*self.rho
            X_inlier_left = X_val -diff
            X_inlier_right = X_val + diff
            for i in range(5):
                X_inlier_left = np.concatenate([X_inlier_left,X_val - diff*(i+2)])
                X_inlier_right= np.concatenate([X_inlier_right,X_val + diff*(i+2)])



            samples = np.concatenate([X_inlier_left,X_tmp, X_inlier_right])
            samples = np.sort(samples)

            samples = np.unique(samples)

            y_pred, sigma = self.GPs.predict(samples.reshape(-1,1))
            if np.max(y_pred) <  0.95:

                continue

            max_interval = 0
            max_interval_start = None
            max_interval_end = None

            for i in range(len(y_pred)):
                if y_pred[i] >=0.95 and sigma[i] <= 0.1:
                    if max_interval_start is None:
                        max_interval_start = samples[i]
                    else:
                        interval = samples[i] - max_interval_start
                        if interval > max_interval:
                            max_interval = interval
                            max_interval_end = samples[i]
                else:
                    max_interval_start = None
            if max_interval_start is not None and max_interval_end is not None:

                self.ext_bound[j, 0] = max_interval_end - max_interval
                self.ext_bound[j, 1] = max_interval_end





    def init_bound(self, int_bound, n_dim):
        if type(int_bound) != np.ndarray:
            self.int_bound = np.zeros((n_dim, 2))
            self.int_bound[:, 0] = -np.inf
            self.int_bound[:, 1] = np.inf
        else:
            self.int_bound = int_bound
        self.ext_bound = np.zeros((n_dim, 2))
        self.ext_bound[:, 0] = -np.inf
        self.ext_bound[:, 1] = np.inf


    def get_init_anchor(self, X):
        anchor = np.zeros((50, X.shape[1]))
        for j in range(X.shape[1]):
            if X.size == 0:
                continue
            anchor[:, j] = np.random.uniform(np.min(X[:,j]), np.max(X[:,j]), 50)
        return anchor


    def get_sampling_radius(self, X):
        if X.size == 0:

            return np.zeros(X.shape[1]) + self.rho

        max_vals = np.max(X, axis=0)
        min_vals = np.min(X, axis=0)


        if max_vals.size == 0 or min_vals.size == 0:

            return np.zeros(X.shape[1]) + self.rho


        radius = (max_vals -min_vals) * self.rho
        radius[radius == 0] = self.rho
        return radius




    def get_cov(self, radius):
        cov = np.diag(radius/4)
        return cov


    def explorer_sampling(self, x, cov):
        X_sample = np.random.multivariate_normal(x[0], cov, size=self.n_sampling)

        return X_sample


    def grad_sign(self, grad):
        grad[grad > 0] = 1
        grad[grad < 0] = -1
        return grad


    def check_reach_int_bound(self, X, dim, dr):
        flag = np.zeros(X.shape[0])
        bound = self.int_bound[dim, dr]
        if dr == 0:
            flag[np.where(X[:, dim] <= bound)] = -1
        else:
            flag[np.where(X[:, dim] > bound)] = -1
        return flag


    def check_go_backward(self, X, X_next, dim, dr):
        flag = np.zeros(X.shape[0])
        diff = X_next[:, dim] - X[:, dim]
        if dr == 0:
            flag[np.where(diff > 0)] = -1
        else:
            flag[np.where(diff < 0)] = -1
        return flag


    def check_reach_thres(self, s):
        flag = np.zeros(s.shape[0])
        flag[np.where(s <= self.thres)] = 0
        flag[np.where(s > self.thres)] = 1
        return flag


    def check_anchor_move(self, s, s_init):
        diff = (s.max() - s_init.max()) / s_init.max()
        if diff < self.eps:
            return 0
        else:
            return 1


    def set_bound(self):
        if (self.ext_bound[:, 1] == -np.inf).all():
            self.bound = self.ext_bound
        self.bound = np.zeros(self.int_bound.shape)
        n_dim = self.int_bound.shape[0]
        for dim in range(n_dim):
            self.bound[dim, 0] = max(self.int_bound[dim, 0], self.ext_bound[dim, 0])
            self.bound[dim, 1] = min(self.int_bound[dim, 1], self.ext_bound[dim, 1])


    def get_bound(self):
        return self.bound


    def predict_sample(self, x):
        result = ((x > self.bound[:, 0]) & (x <= self.bound[:, 1])).sum()
        y_pred = int(result != x.shape[0])
        return y_pred



    def get_acquisition_function(self, gp, X):
        """
        Calculate the acquisition function values for given points X based on the GP model.
        """
        mu, sigma = gp.predict(X)

        return (sigma * np.random.randn(*sigma.shape))  # Example: Stochastic sampling based on uncertainty


